%% Simulates option data for CEV model

S_0  = 100;%0.05;  %Initial interest rate level
r    = .05;  %Interest rate
q    = r/2;  %dividend yield
T    = 0.5;    %Time (in years); change to 1 for one year

sigma=1.19;
gamma=1.35/2-1;

N_sim = 10000000;

M = 100;
delta=T/M;

Spath = Simulate_Diffusion_func_CEV2( N_sim, M, T, S_0, gamma,sigma,r,q);

F=Spath;CF=F;

disp ("spot price of the future");
disp (CF(1,1));
S=CF; 
S=abs(CF); %avoid a few small non-negative values
Spot=mean(S(:,1));

[f,x]=ksdensity(S(1:N_sim,M+1),20:2:220);plot(x,f);

Kvec1 = 10:10:250;
Kvec2 = 70:5:150;
Kvec3 = 90:1:120; 
Kvec = unique([Kvec1,Kvec2,Kvec3]);

dt = delta; disc = exp(-r*dt);discc = exp(-r*T);
[prices_put, stdErrs_put] = Price_MC_American_Strikes_func(S, disc, 0, Kvec );
% 
 prices_eo_put=Price_MC_EO_Strikes_func(S,discc,0,Kvec);
% 
 [prices_call, stdErrs_call] = Price_MC_American_Strikes_func(S, disc, 1, Kvec );
% 
 prices_eo_call=Price_MC_EO_Strikes_func(S,discc,1,Kvec);

%0
 save('CEV_spd_x6m1.mat','prices_put', 'stdErrs_put','prices_eo_put','prices_call', 'stdErrs_call','prices_eo_call','Spot');
 save('CEV_den_x6m1.mat','x','f');
 %save('CEV_spd_x1y1_spath.mat','S');
 

